;-------------------------------------------------------------------------
; Native serial i/o functionality using SID/SOD for micro8085_cilb
; Functions below assumes support for INTEL 8085 "undocumented" opcodes

        SECTION code_clib

        EXTERN  pspiclk

        PUBLIC  _spi_rxbuf
        PUBLIC  _spi_rxbyte
        PUBLIC  _spi_txbuf
        PUBLIC  _spi_txbyte
        PUBLIC  sprxbf
        PUBLIC  spirx
        PUBLIC  sptxbf
        PUBLIC  spitx

;-------------------------------------------------------------------------
; *** SPI IMPLEMENTATION USING SID/SOD AND IO WRITE AS CLK ***
; SDOUT AND SDIN ARE SOFTWARE DRIVEN SERIAL OUTPUT AND INPUT FUNCTIONS
; USING 8085 PINS SOD AND SID FOR DATA TRANSFER AND A DUMMY I/O WRITE
; TO GENERATE CLOCK PULSE. SERIAL DATA OUTPUT FREQUENCY IS ABOUT 64KBIT
; WHEN INCLUDING CALL AND RETURN YIELDS A CHARACTER BACK TO BACK TIME OF
; ABOUT 140 MICROSEC. SERIAL DATA INPUT IS SLIGHTLY FASTER. CLK PULSE IS
; GENERATED BY A DUMMY WRITE TO I/O ADDR WHERE THE CHIP SELECT IS NOR'D
; WITH THE WR STROBE TO GENERATE A 460 NANOSEC POSITIVE PULSE. TO IMPROVE
; TIMING THE CLOCK PULSE IS PROLONGED TO 1700 NANOSEC BY R/C AND LOGIC.
;-------------------------------------------------------------------------
; extern void spi_rxbuf(uint8 *pData, uint16 Length);
; extern uint8 spi_rxbyte(void);
;-------------------------------------------------------------------------
_spi_rxbuf:
        ld      de,sp+2         ;get arguments from stack
        ld      hl,(de)         ;last pushed is length
        ld      b,h             ;copy to bc
        ld      c,l             ;as loop counter
        inc     de              ;get to first
        inc     de              ;argument position
        ld      hl,(de)         ;first pushed is ptr
sprxbf: dec     bc              ;pre decrement counter
        jp      k,spirx2        ;when using k-flag
        push    hl              ;caller saves
        call    spirx           ;clock in byte to a
        pop     hl              ;restore
        ld      (hl),a          ;put byte to buf
        inc     hl              ;bump ptr
        jp      sprxbf          ;and loop
_spi_rxbyte:
spirx:  ld      d,80H           ;AND MASK IN D
        ld      hl,0800H        ;NBR OF BITS & RETURN VAL
spirx1: rim                     ;READ CURRRENT BIT
        out     (pspiclk),a     ;ISSUE A CLOCK PULSE
        and     d               ;MASK THE CURRENT BIT
        or      l               ;MERGE WITH PREVIOUS
        rlca                    ;ROTATE ONE STEP
        ld      l,a             ;AND SAVE IT
        dec     h               ;COUNT ITERATIONS
        jp      nz,spirx1       ;LOOP IF NOT READY
spirx2: ret                     ;A PLUS HL HOLDS RETVAL

;-------------------------------------------------------------------------
; extern void spi_txbuf(uint8 *pData, uint16 Length);
; extern void spi_txbyte(uint8 Data);
;-------------------------------------------------------------------------
_spi_txbuf:
        ld      de,sp+2         ;get arguments from stack
        ld      hl,(de)         ;last pushed is length
        ld      b,h             ;copy to bc
        ld      c,l             ;as loop counter
        inc     de              ;get to first
        inc     de              ;argument position
        ld      hl,(de)         ;first pushed is ptr
sptxbf: dec     bc              ;pre decrement counter
        jp      k,spitx2        ;when using k-flag
        ld      a,(hl)          ;get byte from buf
        inc     hl              ;bump ptr
        push    hl              ;caller saves
        call    spitx           ;clock out byte in a
        pop     hl              ;restore
        jp      sptxbf          ;and loop
_spi_txbyte:
        ld      de,sp+2         ;GET ARGUMENT
        ld      a,(de)          ;FROM STACK
spitx:  ld      de,8040H        ;AND & OR MASK IN DE
        ld      h,8H            ;NBR OF BITS TO SHIFT
        ld      l,a             ;KEEP OUTPUT BYTE IN L
spitx1: and     d               ;MASK THE CURRENT BIT
        or      e               ;SET BIT FOR SOD ENABLE
        sim                     ;WRITE IT TO PIN
        ld      a,l             ;RESTORE BYTE
        rlca                    ;ROTATE ONE STEP
        ld      l,a             ;AND SAVE IT
        out     (pspiclk),a     ;ISSUE A CLOCK PULSE
        dec     h               ;COUNT ITERATIONS
        jp      nz,spitx1       ;LOOP IF NOT READY
        ld      a,e             ;FINISH WITH A '0'
        sim                     ;WRITE TO PIN
spitx2: ret                     ;AND WE'RE DONE
